export DEBUG=0
export CUDA_VISIBLE_DEVICES=0,1,2,3
export VLLMURL=http://localhost:8000/v1
export VLLM=1
export VLLM_ALLOW_LONG_MAX_MODEL_LEN=1

trap 'kill $(jobs -p)' SIGTERM
models=("YOUR_SFT_MODEL")


for model in "${!models[@]}"; do
    echo "Processing model: ${models[$model]}"
    
    python -m vllm.entrypoints.openai.api_server --model ${models[$model]} \
        --max-model-len 8192 --tensor-parallel-size 4 &
    sleep 240

    python generate_preference_data.py \
        --model=${models[$model]} \
        --output-path="outputs/UltraFeedback" \
        --additional-info "" \
        --rounds 0 \
        --num-proc 64 \
        --temperature 0.8 \
        --n 5 \
        --max_turns 10 \
        --dataset_path "HuggingFaceH4/ultrafeedback_binarized"

done




